/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;

public abstract class PreviewOptionsScreen
extends BaseOptionsScreen {
    private boolean adjustingPosition;
    private boolean adjustDragging;
    private double dragOffsetX;
    private double dragOffsetY;

    public PreviewOptionsScreen(@Nullable class_437 parent, class_2561 title) {
        super(parent, title);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAdjustingPosition() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof PreviewOptionsScreen)) return false;
        PreviewOptionsScreen screen = (PreviewOptionsScreen)class_4372;
        if (!screen.adjustingPosition) return false;
        return true;
    }

    private static float calculateAnchor(float center, float size, float rectSize) {
        float anchor = center / size;
        if (anchor < 0.25f) {
            return 0.0f;
        }
        if (anchor > 0.75f) {
            return 1.0f;
        }
        float halfRectSize = rectSize / 2.0f;
        float tolerance = Math.min(15.0f, halfRectSize / 2.0f - 3.0f);
        if (Math.abs(center + halfRectSize - size / 2.0f) < tolerance) {
            return 1.0f;
        }
        if (Math.abs(center - halfRectSize - size / 2.0f) < tolerance) {
            return 0.0f;
        }
        return 0.5f;
    }

    private static float maybeSnap(float value) {
        if (!JadeUI.hasControlDown() && value > 0.475f && value < 0.525f) {
            return 0.5f;
        }
        return value;
    }

    @Override
    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        super.method_25426();
        if (this.field_22787.field_1687 != null) {
            class_5676 previewButton = class_5676.method_32607((class_2561)OptionsList.OPTION_ON, (class_2561)OptionsList.OPTION_OFF, (boolean)Jade.history().previewOverlay).method_32617(10, Objects.requireNonNull(this.saveButton).method_46427(), 85, 20, (class_2561)class_2561.method_43471((String)"gui.jade.preview"), (button, value) -> {
                Jade.history().previewOverlay = value;
                Objects.requireNonNull(this.saver).run();
            });
            this.method_37063((class_364)previewButton);
        }
    }

    public boolean forcePreviewOverlay() {
        Objects.requireNonNull(this.field_22787);
        if (this.adjustingPosition) {
            return true;
        }
        if (!this.method_25397() || this.options == null) {
            return false;
        }
        OptionsList.Entry entry = (OptionsList.Entry)this.options.method_25334();
        if (entry == null || entry.mainWidget() == null) {
            return false;
        }
        return this.options.forcePreview.contains((Object)entry);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!this.adjustingPosition) {
            return super.method_25402(event, doubleClick);
        }
        Objects.requireNonNull(this.field_22787);
        Rect2f rect = OverlayRenderer.animation.expectedRect;
        if (rect.contains((int)event.comp_4798(), (int)event.comp_4799())) {
            this.method_25398(true);
            this.adjustDragging = true;
            float centerX = rect.getX() + rect.getWidth() / 2.0f;
            float centerY = rect.getY() + rect.getHeight() / 2.0f;
            this.dragOffsetX = event.comp_4798() - (double)centerX;
            this.dragOffsetY = event.comp_4799() - (double)centerY;
        } else {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            int xIndex = class_3532.method_15340((int)((int)(event.comp_4798() / ((double)this.field_22789 / 3.0))), (int)0, (int)2);
            int yIndex = class_3532.method_15340((int)((int)(event.comp_4799() / ((double)this.field_22790 / 3.0))), (int)0, (int)2);
            if (xIndex == 1 && yIndex == 1) {
                this.adjustingPosition = false;
                this.adjustDragging = false;
            } else {
                IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
                overlay.setOverlayPosX(IWailaConfig.get().accessibility().tryFlip((float)xIndex / 2.0f));
                overlay.setOverlayPosY(1.0f - (float)yIndex / 2.0f);
                overlay.setAnchorX(IWailaConfig.get().accessibility().tryFlip((float)xIndex / 2.0f));
                overlay.setAnchorY((float)yIndex / 2.0f);
            }
        }
        return true;
    }

    public boolean method_25406(class_11909 event) {
        if (this.adjustingPosition) {
            this.method_25398(false);
            this.adjustDragging = false;
            return true;
        }
        return super.method_25406(event);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_16803(class_11908 keyEvent) {
        Objects.requireNonNull(this.field_22787);
        if (this.adjustingPosition) {
            if (keyEvent.method_74231()) {
                this.adjustingPosition = false;
                this.adjustDragging = false;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
            return true;
        }
        return super.method_16803(keyEvent);
    }

    public boolean method_25403(class_11909 event, double d, double e) {
        if (this.adjustingPosition && this.adjustDragging) {
            float centerX = (float)event.comp_4798() - (float)this.dragOffsetX;
            float centerY = (float)event.comp_4799() - (float)this.dragOffsetY;
            Rect2f rect = OverlayRenderer.animation.expectedRect;
            float rectWidth = rect.getWidth();
            float rectHeight = rect.getHeight();
            float anchorX = PreviewOptionsScreen.calculateAnchor(centerX, this.field_22789, rectWidth);
            float anchorY = PreviewOptionsScreen.calculateAnchor(centerY, this.field_22790, rectHeight);
            float posX = (centerX + rectWidth * (anchorX - 0.5f)) / (float)this.field_22789;
            float posY = 1.0f - (centerY + rectHeight * (anchorY - 0.5f)) / (float)this.field_22790;
            IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
            IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
            overlay.setOverlayPosX(accessibility.tryFlip(PreviewOptionsScreen.maybeSnap(posX)));
            overlay.setOverlayPosY(PreviewOptionsScreen.maybeSnap(posY));
            overlay.setAnchorX(accessibility.tryFlip(anchorX));
            overlay.setAnchorY(anchorY);
            return true;
        }
        return super.method_25403(event, d, e);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.adjustingPosition) {
            super.method_25394(guiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
            guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -2139062144);
            class_5250 text = class_2561.method_43471((String)"config.jade.overlay_pos.exit");
            class_327 font = DisplayHelper.font();
            int textWidth = font.method_27525((class_5348)text);
            int x = (this.field_22789 - textWidth) / 2;
            int y = this.field_22790 / 2 - 7;
            Objects.requireNonNull(font);
            guiGraphics.method_25294(x - 4, y - 4, x + textWidth + 4, y + 9 + 4, -2013265920);
            guiGraphics.method_27535(font, (class_2561)text, x, y, -1);
            IWailaConfig.Overlay config = IWailaConfig.get().overlay();
            Rect2f rect = OverlayRenderer.animation.expectedRect;
            if (rect.contains(mouseX, mouseY)) {
                guiGraphics.method_74037(class_11876.field_62458);
            }
            if (IWailaConfig.get().general().isDebug()) {
                int anchorX = (int)(rect.getX() + rect.getWidth() * config.getAnchorX());
                int anchorY = (int)(rect.getY() + rect.getHeight() * config.getAnchorY());
                guiGraphics.method_25294(anchorX - 2, anchorY - 2, anchorX + 1, anchorY + 1, -65536);
            }
            if (config.getOverlayPosX() == 0.5f) {
                guiGraphics.method_25294(this.field_22789 / 2, (int)(rect.getY() - 5.0f), this.field_22789 / 2 + 1, (int)(rect.getY() + rect.getHeight() + 4.0f), -16776961);
            }
            if (config.getOverlayPosY() == 0.5f) {
                guiGraphics.method_25294((int)(rect.getX() - 5.0f), this.field_22790 / 2, (int)(rect.getX() + rect.getWidth() + 4.0f), this.field_22790 / 2 + 1, -16776961);
            }
        } else {
            super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void startAdjustingPosition() {
        this.adjustingPosition = true;
    }

    protected void method_37056(class_6382 narrationElementOutput) {
        if (this.adjustingPosition) {
            narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.jade.adjusting_position"));
            return;
        }
        super.method_37056(narrationElementOutput);
    }

    protected boolean method_48262() {
        return !this.adjustingPosition;
    }
}

