/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.UUID;
import net.minecraft.class_10583;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6025;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.PlayerNameLookup;

public class AnimalOwnerProvider
implements StreamServerDataProvider<EntityAccessor, class_2561> {
    public static final AnimalOwnerProvider INSTANCE = new AnimalOwnerProvider();

    @Override
    public @Nullable class_2561 streamData(EntityAccessor accessor) {
        class_1297 entity;
        class_3218 level = (class_3218)accessor.getLevel();
        UUID uuid = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
        class_1297 class_12972 = entity = uuid == null ? null : level.method_66347(uuid);
        if (entity != null) {
            return ObjectNameProvider.getEntityName(entity, false);
        }
        String name = PlayerNameLookup.get(uuid, level.method_8503().method_73550());
        return name == null ? null : class_2561.method_43470((String)name);
    }

    @Override
    public class_9139<class_9129, class_2561> streamCodec() {
        return class_8824.field_48540;
    }

    public static @Nullable UUID getOwnerUUID(class_1297 entity) {
        class_6025 ownableEntity;
        class_10583 reference;
        if (entity instanceof class_6025 && (reference = (ownableEntity = (class_6025)entity).method_66287()) != null) {
            return reference.method_66263();
        }
        return null;
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        class_1297 entity = accessor.getEntity();
        if (!(entity instanceof class_6025)) {
            return false;
        }
        UUID ownerUUID = AnimalOwnerProvider.getOwnerUUID(entity);
        if (ownerUUID == null) {
            return true;
        }
        if (!PlayerNameLookup.isFetched(ownerUUID)) {
            return false;
        }
        return ClientProxy.lookupPlayerName(ownerUUID) == null;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_ANIMAL_OWNER;
    }

    public static class Client
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            class_2561 name = INSTANCE.decodeFromData(accessor).orElse(null);
            if (name == null) {
                UUID uuid = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
                String playerName = ClientProxy.lookupPlayerName(uuid);
                if (playerName == null) {
                    return;
                }
                name = class_2561.method_43470((String)playerName);
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"jade.owner", (Object[])new Object[]{name}));
        }

        @Override
        public class_2960 getUid() {
            return JadeIds.MC_ANIMAL_OWNER;
        }
    }
}

