/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.inventory;

import com.natamus.collective_common_neoforge.functions.GearFunctions;
import com.natamus.collective_common_neoforge.implementations.networking.api.Dispatcher;
import com.natamus.starterkit_common_neoforge.config.ConfigHandler;
import com.natamus.starterkit_common_neoforge.data.ConstantsClient;
import com.natamus.starterkit_common_neoforge.data.VariablesClient;
import com.natamus.starterkit_common_neoforge.functions.StarterClientFunctions;
import com.natamus.starterkit_common_neoforge.inventory.StarterKitAbstractContainerScreen;
import com.natamus.starterkit_common_neoforge.inventory.StarterKitInventoryMenu;
import com.natamus.starterkit_common_neoforge.networking.packets.ToServerSendKitChoicePacket;
import com.natamus.starterkit_common_neoforge.util.Util;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StarterKitInventoryScreen
extends StarterKitAbstractContainerScreen<StarterKitInventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean widthTooNarrow;
    private boolean buttonClicked;

    public StarterKitInventoryScreen(Player player) {
        super(new StarterKitInventoryMenu(player), VariablesClient.cachedStarterKitInventory, (Component)Component.literal((String)Util.formatKitName(VariablesClient.cachedStarterKitName)).withStyle(ChatFormatting.BOLD));
        if (player == null) {
            return;
        }
        Inventory kitInventory = VariablesClient.cachedStarterKitInventory;
        if (kitInventory == null) {
            return;
        }
        NonNullList itemList = kitInventory.getNonEquipmentItems();
        EntityEquipment entityEquipment = GearFunctions.getEntityEquipment((Inventory)kitInventory);
        List<ItemStack> armourList = Arrays.asList(entityEquipment.get(EquipmentSlot.HEAD), entityEquipment.get(EquipmentSlot.CHEST), entityEquipment.get(EquipmentSlot.LEGS), entityEquipment.get(EquipmentSlot.FEET));
        List<ItemStack> offhandList = Arrays.asList(entityEquipment.get(EquipmentSlot.OFFHAND));
        player.getInventory().setSelectedSlot(0);
        player.setItemSlot(EquipmentSlot.HEAD, armourList.get(0));
        player.setItemSlot(EquipmentSlot.CHEST, armourList.get(1));
        player.setItemSlot(EquipmentSlot.LEGS, armourList.get(2));
        player.setItemSlot(EquipmentSlot.FEET, armourList.get(3));
        player.setItemSlot(EquipmentSlot.MAINHAND, (ItemStack)itemList.get(0));
        player.setItemSlot(EquipmentSlot.OFFHAND, offhandList.get(0));
        ConstantsClient.mc.options.hideGui = true;
    }

    @Override
    public void containerTick() {
    }

    @Override
    protected void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.setupButtons();
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 104, this.height / 2 - 22);
    }

    private void setupButtons() {
        Button previousKitButton = Button.builder((Component)Component.literal((String)" < "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.minecraft.player, false)).bounds(this.width / 2 + 13, this.height / 2 - 21, 30, 16).build();
        Button nextKitButton = Button.builder((Component)Component.literal((String)" > "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.minecraft.player, true)).bounds(this.width / 2 + 47, this.height / 2 - 21, 30, 16).build();
        Button chooseKitButton = Button.builder((Component)Component.literal((String)"Choose Starter Kit"), button -> {
            StarterClientFunctions.clearPriorEquipmentCache();
            Dispatcher.sendToServer((Object)new ToServerSendKitChoicePacket(VariablesClient.cachedStarterKitName));
            ConstantsClient.mc.setScreen(null);
        }).bounds(this.width / 2 - 60, this.height / 2 + 88, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)previousKitButton);
        this.addRenderableWidget((GuiEventListener)nextKitButton);
        this.addRenderableWidget((GuiEventListener)chooseKitButton);
    }

    @Override
    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String playerName = "";
        if (this.minecraft.player != null) {
            playerName = this.minecraft.player.getName().getString();
        }
        String headerString = ConfigHandler.chooseKitText.replace("%s", playerName);
        if (playerName.isEmpty()) {
            headerString = headerString.replace(", p", "P");
        }
        MutableComponent headerComponent = Component.literal((String)headerString).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD);
        int headerWidth = this.font.width((FormattedText)headerComponent);
        guiGraphics.drawString(this.font, (Component)headerComponent, -((headerWidth - this.imageWidth) / 2), -16, -1, true);
        String fullKitName = Util.formatKitName(VariablesClient.cachedStarterKitName);
        Object kitName = fullKitName;
        while (this.font.width((String)kitName) > 88) {
            kitName = Util.removeLastChar((String)kitName);
        }
        if (!fullKitName.equalsIgnoreCase((String)kitName)) {
            kitName = (String)kitName + "...";
        }
        guiGraphics.drawString(this.font, (String)kitName, 79, 7, -13487616, false);
        if (VariablesClient.cachedStarterKitDescriptions.containsKey(VariablesClient.cachedStarterKitName.toLowerCase())) {
            Matrix3x2fStack matrixStack = guiGraphics.pose();
            matrixStack.pushMatrix();
            String kitDescription = VariablesClient.cachedStarterKitDescriptions.get(VariablesClient.cachedStarterKitName.toLowerCase());
            MutableComponent descriptionComponent = Component.literal((String)kitDescription);
            matrixStack.scale(0.66f, 0.66f);
            int y = 28;
            List descriptionLines = ComponentRenderUtils.wrapComponents((FormattedText)descriptionComponent, (int)136, (Font)this.minecraft.font);
            for (FormattedCharSequence line : descriptionLines) {
                int x = 120;
                if (y > 28) {
                    x -= 2;
                }
                if (y > 70 && descriptionLines.size() > 6) {
                    guiGraphics.drawString(this.font, "...", x + 132, y, -13487616, false);
                }
                guiGraphics.drawString(this.font, line, x, y, -13487616, false);
                if ((y += 10) <= 80) continue;
                break;
            }
            matrixStack.popMatrix();
        }
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
    }

    @Override
    protected void renderBg(GuiGraphics $$0, float $$1, int $$2, int $$3) {
        int $$4 = this.leftPos;
        int $$5 = this.topPos;
        $$0.blit(RenderPipelines.GUI_TEXTURED, INVENTORY_LOCATION, $$4, $$5, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        StarterKitInventoryScreen.renderEntityInInventoryFollowsMouse($$0, $$4 + 26, $$5 + 8, $$4 + 75, $$5 + 78, 30, 0.0625f, this.xMouse, this.yMouse, (LivingEntity)this.minecraft.player);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics $$0, int $$1, int $$2, int $$3, int $$4, int $$5, float $$6, float $$7, float $$8, LivingEntity $$9) {
        float $$10 = (float)($$1 + $$3) / 2.0f;
        float $$11 = (float)($$2 + $$4) / 2.0f;
        $$0.enableScissor($$1, $$2, $$3, $$4);
        float $$12 = (float)Math.atan(($$10 - $$7) / 40.0f);
        float $$13 = (float)Math.atan(($$11 - $$8) / 40.0f);
        Quaternionf $$14 = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf $$15 = new Quaternionf().rotateX($$13 * 20.0f * ((float)Math.PI / 180));
        $$14.mul((Quaternionfc)$$15);
        float $$16 = $$9.yBodyRot;
        float $$17 = $$9.getYRot();
        float $$18 = $$9.getXRot();
        float $$19 = $$9.yHeadRotO;
        float $$20 = $$9.yHeadRot;
        $$9.yBodyRot = 180.0f + $$12 * 20.0f;
        $$9.setYRot(180.0f + $$12 * 40.0f);
        $$9.setXRot(-$$13 * 20.0f);
        $$9.yHeadRot = $$9.getYRot();
        $$9.yHeadRotO = $$9.getYRot();
        float $$21 = $$9.getScale();
        Vector3f $$22 = new Vector3f(0.0f, $$9.getBbHeight() / 2.0f + $$6 * $$21, 0.0f);
        float $$23 = (float)$$5 / $$21;
        StarterKitInventoryScreen.renderEntityInInventory($$0, $$1, $$2, $$3, $$4, $$23, $$22, $$14, $$15, $$9);
        $$9.yBodyRot = $$16;
        $$9.setYRot($$17);
        $$9.setXRot($$18);
        $$9.yHeadRotO = $$19;
        $$9.yHeadRot = $$20;
        $$0.disableScissor();
    }

    public static void renderEntityInInventory(GuiGraphics $$0, int $$1, int $$2, int $$3, int $$4, float $$5, Vector3f $$6, Quaternionf $$7, @Nullable Quaternionf $$8, LivingEntity $$9) {
        EntityRenderDispatcher $$10 = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer $$11 = $$10.getRenderer((Entity)$$9);
        EntityRenderState $$12 = $$11.createRenderState((Entity)$$9, 1.0f);
        $$0.submitEntityRenderState($$12, $$5, $$6, $$7, $$8, $$1, $$2, $$3, $$4);
    }

    @Override
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return !this.widthTooNarrow && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseButtonEvent);
    }

    @Override
    protected void slotClicked(@NotNull Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
    }

    public void recipesUpdated() {
    }
}

