/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.inventory;

import com.google.common.collect.Sets;
import com.natamus.starterkit_common_fabric.data.Constants;
import com.natamus.starterkit_common_fabric.inventory.SnapbackData;
import java.util.List;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_5684;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public abstract class StarterKitAbstractContainerScreen<T extends class_1703>
extends class_437
implements class_3936<T> {
    public static final class_2960 INVENTORY_LOCATION = class_2960.method_60655((String)"starterkit", (String)"textures/gui/container/inventory.png");
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = class_2960.method_60656((String)"container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/slot_highlight_front");
    private static final float SNAPBACK_SPEED = 100.0f;
    private static final int QUICKDROP_DELAY = 500;
    public static final int SLOT_ITEM_BLIT_OFFSET = 100;
    private static final int HOVER_ITEM_BLIT_OFFSET = 200;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int titleLabelX;
    protected int titleLabelY;
    protected int inventoryLabelX;
    protected int inventoryLabelY;
    protected T menu;
    protected class_2561 playerInventoryTitle;
    @Nullable
    protected class_1735 hoveredSlot;
    @Nullable
    private class_1735 clickedSlot;
    @Nullable
    private class_1735 snapbackEnd;
    @Nullable
    private class_1735 quickdropSlot;
    @Nullable
    private class_1735 lastClickSlot;
    protected int leftPos;
    protected int topPos;
    private boolean isSplittingStack;
    private class_1799 draggingItem;
    private int snapbackStartX;
    private int snapbackStartY;
    private long snapbackTime;
    private class_1799 snapbackItem;
    private long quickdropTime;
    protected Set<class_1735> quickCraftSlots;
    protected boolean isQuickCrafting;
    private int quickCraftingType;
    private int quickCraftingButton;
    private boolean skipNextRelease;
    private int quickCraftingRemainder;
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleclick;
    private class_1799 lastQuickMoved;
    private SnapbackData snapbackData;

    public StarterKitAbstractContainerScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(title);
        if (playerInventory == null) {
            Constants.logger.warn("[Starter Kit] Cannot initiate StarterKitAbstractContainerScreen, the playerInventory is null.");
            return;
        }
        this.draggingItem = class_1799.field_8037;
        this.snapbackItem = class_1799.field_8037;
        this.quickCraftSlots = Sets.newHashSet();
        this.lastQuickMoved = class_1799.field_8037;
        this.menu = menu;
        this.playerInventoryTitle = playerInventory.method_5476();
        this.skipNextRelease = true;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_1799 itemStack;
        int m;
        int l;
        int i = this.leftPos;
        int j = this.topPos;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)i, (float)j);
        this.hoveredSlot = null;
        if (this.menu == null) {
            return;
        }
        for (int k = 0; k < ((class_1703)this.menu).field_7761.size(); ++k) {
            class_1735 slot = (class_1735)((class_1703)this.menu).field_7761.get(k);
            if (slot.method_7682()) {
                this.renderSlot(guiGraphics, slot);
            }
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            this.hoveredSlot = slot;
            l = slot.field_7873;
            m = slot.field_7872;
            if (!this.hoveredSlot.method_51306()) continue;
            this.renderSlotHighlightBack(guiGraphics);
            this.renderSlotHighlightFront(guiGraphics);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        class_1799 class_17992 = itemStack = this.draggingItem.method_7960() ? this.menu.method_34255() : this.draggingItem;
        if (!itemStack.method_7960()) {
            boolean n = true;
            l = this.draggingItem.method_7960() ? 8 : 16;
            String string = null;
            if (!this.draggingItem.method_7960() && this.isSplittingStack) {
                itemStack = itemStack.method_46651(class_3532.method_15386((float)((float)itemStack.method_7947() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemStack = itemStack.method_46651(this.quickCraftingRemainder)).method_7960()) {
                string = String.valueOf(class_124.field_1054) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemStack, mouseX - i - 8, mouseY - j - l, string);
        }
        if (!this.snapbackItem.method_7960()) {
            float f = (float)(class_156.method_658() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = class_1799.field_8037;
            }
            l = this.snapbackEnd.field_7873 - this.snapbackStartX;
            m = this.snapbackEnd.field_7872 - this.snapbackStartY;
            int o = this.snapbackStartX + (int)((float)l * f);
            int p = this.snapbackStartY + (int)((float)m * f);
            this.renderFloatingItem(guiGraphics, this.snapbackItem, o, p, null);
        }
        guiGraphics.method_51448().popMatrix();
    }

    public void method_25420(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
    }

    private void renderSlotHighlightBack(class_332 $$0) {
        if (this.hoveredSlot != null && this.hoveredSlot.method_51306()) {
            $$0.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_SPRITE, this.hoveredSlot.field_7873 - 4, this.hoveredSlot.field_7872 - 4, 24, 24);
        }
    }

    private void renderSlotHighlightFront(class_332 $$0) {
        if (this.hoveredSlot != null && this.hoveredSlot.method_51306()) {
            $$0.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, this.hoveredSlot.field_7873 - 4, this.hoveredSlot.field_7872 - 4, 24, 24);
        }
    }

    protected void renderTooltip(class_332 guiGraphics, int i, int j) {
        if (this.hoveredSlot != null && this.hoveredSlot.method_7681()) {
            class_1799 $$3 = this.hoveredSlot.method_7677();
            if (this.menu.method_34255().method_7960() || this.showTooltipWithItemInHand($$3)) {
                guiGraphics.method_51437(this.field_22793, this.getTooltipFromContainerItem($$3), $$3.method_32347(), i, j, (class_2960)$$3.method_58694(class_9334.field_54198));
            }
        }
    }

    private boolean showTooltipWithItemInHand(class_1799 $$0) {
        return $$0.method_32347().map(class_5684::method_32663).map(class_5684::method_62003).orElse(false);
    }

    protected List<class_2561> getTooltipFromContainerItem(class_1799 stack) {
        return StarterKitAbstractContainerScreen.method_25408((class_310)this.field_22787, (class_1799)stack);
    }

    private void renderFloatingItem(class_332 $$0, class_1799 $$1, int $$2, int $$3, @Nullable String $$4) {
        $$0.method_51427($$1, $$2, $$3);
        $$0.method_51432(this.field_22793, $$1, $$2, $$3 - (this.draggingItem.method_7960() ? 0 : 8), $$4);
    }

    protected void renderLabels(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected abstract void renderBg(class_332 var1, float var2, int var3, int var4);

    protected void renderSlot(class_332 $$0, class_1735 $$1) {
        class_2960 $$12;
        int $$2 = $$1.field_7873;
        int $$3 = $$1.field_7872;
        class_1799 $$4 = $$1.method_7677();
        boolean $$5 = false;
        boolean $$6 = $$1 == this.clickedSlot && !this.draggingItem.method_7960() && !this.isSplittingStack;
        class_1799 $$7 = this.menu.method_34255();
        String $$8 = null;
        if ($$1 == this.clickedSlot && !this.draggingItem.method_7960() && this.isSplittingStack && !$$4.method_7960()) {
            $$4 = $$4.method_46651($$4.method_7947() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains($$1) && !$$7.method_7960()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (class_1703.method_7592((class_1735)$$1, (class_1799)$$7, (boolean)true) && this.menu.method_7615($$1)) {
                $$5 = true;
                int $$9 = Math.min($$7.method_7914(), $$1.method_7676($$7));
                int $$10 = $$1.method_7677().method_7960() ? 0 : $$1.method_7677().method_7947();
                int $$11 = class_1703.method_7617(this.quickCraftSlots, (int)this.quickCraftingType, (class_1799)$$7) + $$10;
                if ($$11 > $$9) {
                    $$11 = $$9;
                    String var10000 = class_124.field_1054.toString();
                    $$8 = var10000 + $$9;
                }
                $$4 = $$7.method_46651($$11);
            } else {
                this.quickCraftSlots.remove($$1);
                this.recalculateQuickCraftRemaining();
            }
        }
        if ($$4.method_7960() && $$1.method_7682() && ($$12 = $$1.method_7679()) != null) {
            $$0.method_52706(class_10799.field_56883, $$12, $$2, $$3, 16, 16);
            $$6 = true;
        }
        if (!$$6) {
            if ($$5) {
                $$0.method_25294($$2, $$3, $$2 + 16, $$3 + 16, -2130706433);
            }
            int $$13 = $$1.field_7873 + $$1.field_7872 * this.imageWidth;
            if ($$1.method_55059()) {
                $$0.method_55231($$4, $$2, $$3, $$13);
            } else {
                $$0.method_51428($$4, $$2, $$3, $$13);
            }
            $$0.method_51432(this.field_22793, $$4, $$2, $$3, $$8);
        }
    }

    private void recalculateQuickCraftRemaining() {
        class_1799 itemStack = this.menu.method_34255();
        if (!itemStack.method_7960() && this.isQuickCrafting) {
            if (this.quickCraftingType == 2) {
                this.quickCraftingRemainder = itemStack.method_7914();
            } else {
                this.quickCraftingRemainder = itemStack.method_7947();
                for (class_1735 slot : this.quickCraftSlots) {
                    class_1799 itemStack2 = slot.method_7677();
                    int i = itemStack2.method_7960() ? 0 : itemStack2.method_7947();
                    int j = Math.min(itemStack.method_7914(), slot.method_7676(itemStack));
                    int k = Math.min(class_1703.method_7617(this.quickCraftSlots, (int)this.quickCraftingType, (class_1799)itemStack) + i, j);
                    this.quickCraftingRemainder -= k - i;
                }
            }
        }
    }

    @Nullable
    private class_1735 findSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((class_1703)this.menu).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((class_1703)this.menu).field_7761.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    public boolean method_25402(@NotNull class_11909 mouseButtonEvent, boolean $$1) {
        if (super.method_25402(mouseButtonEvent, $$1)) {
            return true;
        }
        boolean $$2 = this.field_22787.field_1690.field_1871.method_1433(mouseButtonEvent) && this.field_22787.field_1724.method_56992();
        class_1735 $$3 = this.getHoveredSlot(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
        this.doubleclick = this.lastClickSlot == $$3 && $$1;
        this.skipNextRelease = false;
        if (mouseButtonEvent.method_74245() != 0 && mouseButtonEvent.method_74245() != 1 && !$$2) {
            this.checkHotbarMouseClicked(mouseButtonEvent);
        } else {
            int $$4 = this.leftPos;
            int $$5 = this.topPos;
            boolean $$6 = this.hasClickedOutside(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799(), $$4, $$5);
            int $$7 = -1;
            if ($$3 != null) {
                $$7 = $$3.field_7874;
            }
            if ($$6) {
                $$7 = -999;
            }
            if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue() && $$6 && this.menu.method_34255().method_7960()) {
                this.method_25419();
                return true;
            }
            if ($$7 != -1) {
                if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                    if ($$3 != null && $$3.method_7681()) {
                        this.clickedSlot = $$3;
                        this.draggingItem = class_1799.field_8037;
                        this.isSplittingStack = mouseButtonEvent.method_74245() == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.isQuickCrafting) {
                    if (this.menu.method_34255().method_7960()) {
                        if ($$2) {
                            this.slotClicked($$3, $$7, mouseButtonEvent.method_74245(), class_1713.field_7796);
                        } else {
                            boolean $$8 = $$7 != -999 && mouseButtonEvent.method_74239();
                            class_1713 $$9 = class_1713.field_7790;
                            if ($$8) {
                                this.lastQuickMoved = $$3 != null && $$3.method_7681() ? $$3.method_7677().method_7972() : class_1799.field_8037;
                                $$9 = class_1713.field_7794;
                            } else if ($$7 == -999) {
                                $$9 = class_1713.field_7795;
                            }
                            this.slotClicked($$3, $$7, mouseButtonEvent.method_74245(), $$9);
                        }
                        this.skipNextRelease = true;
                    } else {
                        this.isQuickCrafting = true;
                        this.quickCraftingButton = mouseButtonEvent.method_74245();
                        this.quickCraftSlots.clear();
                        if (mouseButtonEvent.method_74245() == 0) {
                            this.quickCraftingType = 0;
                        } else if (mouseButtonEvent.method_74245() == 1) {
                            this.quickCraftingType = 1;
                        } else if ($$2) {
                            this.quickCraftingType = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = $$3;
        return true;
    }

    protected boolean hasClickedOutside(double $$0, double $$1, int $$2, int $$3) {
        return $$0 < (double)$$2 || $$1 < (double)$$3 || $$0 >= (double)($$2 + this.imageWidth) || $$1 >= (double)($$3 + this.imageHeight);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        class_1735 slot = this.findSlot(mouseX, mouseY);
        class_1799 itemStack = this.menu.method_34255();
        if (this.clickedSlot != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
            if (button == 0 || button == 1) {
                if (this.draggingItem.method_7960()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.method_7677().method_7960()) {
                        this.draggingItem = this.clickedSlot.method_7677().method_7972();
                    }
                } else if (this.draggingItem.method_7947() > 1 && slot != null && class_1703.method_7592((class_1735)slot, (class_1799)this.draggingItem, (boolean)false)) {
                    long l = class_156.method_658();
                    if (this.quickdropSlot == slot) {
                        if (l - this.quickdropTime > 500L) {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, 0, class_1713.field_7790);
                            this.slotClicked(slot, slot.field_7874, 1, class_1713.field_7790);
                            this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, 0, class_1713.field_7790);
                            this.quickdropTime = l + 750L;
                            this.draggingItem.method_7934(1);
                        }
                    } else {
                        this.quickdropSlot = slot;
                        this.quickdropTime = l;
                    }
                }
            }
        } else if (this.isQuickCrafting && slot != null && !itemStack.method_7960() && (itemStack.method_7947() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && class_1703.method_7592((class_1735)slot, (class_1799)itemStack, (boolean)true) && slot.method_7680(itemStack) && this.menu.method_7615(slot)) {
            this.quickCraftSlots.add(slot);
            this.recalculateQuickCraftRemaining();
        }
        return true;
    }

    public boolean method_25406(class_11909 $$0) {
        class_1735 $$1 = this.getHoveredSlot($$0.comp_4798(), $$0.comp_4799());
        int $$2 = this.leftPos;
        int $$3 = this.topPos;
        boolean $$4 = this.hasClickedOutside($$0.comp_4798(), $$0.comp_4799(), $$2, $$3);
        int $$5 = -1;
        if ($$1 != null) {
            $$5 = $$1.field_7874;
        }
        if ($$4) {
            $$5 = -999;
        }
        if (this.doubleclick && $$1 != null && $$0.method_74245() == 0 && this.menu.method_7613(class_1799.field_8037, $$1)) {
            if ($$0.method_74239()) {
                if (!this.lastQuickMoved.method_7960()) {
                    for (class_1735 $$6 : ((class_1703)this.menu).field_7761) {
                        if ($$6 == null || !$$6.method_7674((class_1657)this.field_22787.field_1724) || !$$6.method_7681() || $$6.field_7871 != $$1.field_7871 || !class_1703.method_7592((class_1735)$$6, (class_1799)this.lastQuickMoved, (boolean)true)) continue;
                        this.slotClicked($$6, $$6.field_7874, $$0.method_74245(), class_1713.field_7794);
                    }
                }
            } else {
                this.slotClicked($$1, $$5, $$0.method_74245(), class_1713.field_7793);
            }
            this.doubleclick = false;
        } else {
            if (this.isQuickCrafting && this.quickCraftingButton != $$0.method_74245()) {
                this.isQuickCrafting = false;
                this.quickCraftSlots.clear();
                this.skipNextRelease = true;
                return true;
            }
            if (this.skipNextRelease) {
                this.skipNextRelease = false;
                return true;
            }
            if (this.clickedSlot != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                if ($$0.method_74245() == 0 || $$0.method_74245() == 1) {
                    if (this.draggingItem.method_7960() && $$1 != this.clickedSlot) {
                        this.draggingItem = this.clickedSlot.method_7677();
                    }
                    boolean $$7 = class_1703.method_7592((class_1735)$$1, (class_1799)this.draggingItem, (boolean)false);
                    if ($$5 != -1 && !this.draggingItem.method_7960() && $$7) {
                        this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, $$0.method_74245(), class_1713.field_7790);
                        this.slotClicked($$1, $$5, 0, class_1713.field_7790);
                        if (this.menu.method_34255().method_7960()) {
                            this.snapbackData = null;
                        } else {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, $$0.method_74245(), class_1713.field_7790);
                            this.snapbackData = new SnapbackData(this.draggingItem, new Vector2i((int)$$0.comp_4798(), (int)$$0.comp_4799()), new Vector2i(this.clickedSlot.field_7873 + $$2, this.clickedSlot.field_7872 + $$3), class_156.method_658());
                        }
                    } else if (!this.draggingItem.method_7960()) {
                        this.snapbackData = new SnapbackData(this.draggingItem, new Vector2i((int)$$0.comp_4798(), (int)$$0.comp_4799()), new Vector2i(this.clickedSlot.field_7873 + $$2, this.clickedSlot.field_7872 + $$3), class_156.method_658());
                    }
                    this.clearDraggingState();
                }
            } else if (this.isQuickCrafting && !this.quickCraftSlots.isEmpty()) {
                this.slotClicked(null, -999, class_1703.method_7591((int)0, (int)this.quickCraftingType), class_1713.field_7789);
                for (class_1735 $$8 : this.quickCraftSlots) {
                    this.slotClicked($$8, $$8.field_7874, class_1703.method_7591((int)1, (int)this.quickCraftingType), class_1713.field_7789);
                }
                this.slotClicked(null, -999, class_1703.method_7591((int)2, (int)this.quickCraftingType), class_1713.field_7789);
            } else if (!this.menu.method_34255().method_7960()) {
                if (this.field_22787.field_1690.field_1871.method_1433($$0)) {
                    this.slotClicked($$1, $$5, $$0.method_74245(), class_1713.field_7796);
                } else {
                    boolean $$9;
                    boolean bl = $$9 = $$5 != -999 && $$0.method_74239();
                    if ($$9) {
                        this.lastQuickMoved = $$1 != null && $$1.method_7681() ? $$1.method_7677().method_7972() : class_1799.field_8037;
                    }
                    this.slotClicked($$1, $$5, $$0.method_74245(), $$9 ? class_1713.field_7794 : class_1713.field_7790);
                }
            }
        }
        this.isQuickCrafting = false;
        return true;
    }

    public void clearDraggingState() {
        this.draggingItem = class_1799.field_8037;
        this.clickedSlot = null;
    }

    private boolean isHovering(class_1735 slot, double mouseX, double mouseY) {
        return this.isHovering(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected void slotClicked(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
        if (slot != null) {
            slotId = slot.field_7874;
        }
        this.field_22787.field_1761.method_2906(((class_1703)this.menu).field_7763, slotId, mouseButton, type, (class_1657)this.field_22787.field_1724);
    }

    protected void handleSlotStateChanged(int slotId, int containerId, boolean newState) {
        this.field_22787.field_1761.method_54634(slotId, containerId, newState);
    }

    public boolean method_25404(@NotNull class_11908 keyEvent) {
        if (super.method_25404(keyEvent)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyEvent)) {
            this.method_25419();
            return true;
        }
        this.checkHotbarKeyPressed(keyEvent);
        if (this.hoveredSlot != null && this.hoveredSlot.method_7681()) {
            if (this.field_22787.field_1690.field_1871.method_1417(keyEvent)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, 0, class_1713.field_7796);
            } else if (this.field_22787.field_1690.field_1869.method_1417(keyEvent)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, keyEvent.method_74240() ? 1 : 0, class_1713.field_7795);
            }
        }
        return true;
    }

    protected boolean checkHotbarKeyPressed(class_11908 $$0) {
        if (this.menu.method_34255().method_7960() && this.hoveredSlot != null) {
            if (this.field_22787.field_1690.field_1831.method_1417($$0)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, 40, class_1713.field_7791);
                return true;
            }
            for (int $$1 = 0; $$1 < 9; ++$$1) {
                if (!this.field_22787.field_1690.field_1852[$$1].method_1417($$0)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, $$1, class_1713.field_7791);
                return true;
            }
        }
        return false;
    }

    private void checkHotbarMouseClicked(class_11909 mouseButtonEvent) {
        if (this.hoveredSlot != null && this.menu.method_34255().method_7960()) {
            if (this.field_22787.field_1690.field_1831.method_1433(mouseButtonEvent)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, 40, class_1713.field_7791);
                return;
            }
            for (int $$1 = 0; $$1 < 9; ++$$1) {
                if (!this.field_22787.field_1690.field_1852[$$1].method_1433(mouseButtonEvent)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, $$1, class_1713.field_7791);
            }
        }
    }

    public void method_25432() {
        if (this.field_22787.field_1724 != null) {
            this.menu.method_7595((class_1657)this.field_22787.field_1724);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public final void method_25393() {
        super.method_25393();
        if (this.field_22787.field_1724.method_5805() && !this.field_22787.field_1724.method_31481()) {
            this.containerTick();
        } else {
            this.field_22787.field_1724.method_7346();
        }
    }

    protected void containerTick() {
    }

    @NotNull
    public T method_17577() {
        return this.menu;
    }

    public void method_25419() {
        this.field_22787.field_1724.method_7346();
        super.method_25419();
    }

    @Nullable
    private class_1735 getHoveredSlot(double $$0, double $$1) {
        for (class_1735 $$2 : ((class_1703)this.menu).field_7761) {
            if (!$$2.method_7682() || !this.isHovering($$2, $$0, $$1)) continue;
            return $$2;
        }
        return null;
    }
}

