/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.globalnarrationtoggle_common_forge.util;

import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.globalnarrationtoggle_common_forge.data.Variables;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Util {
    private static final String OS = System.getProperty("os.name").toUpperCase();
    private static final File dir = new File(Util.getAppDataPath());
    private static final File globalOptionsFile = new File(Util.getGlobalOptionsPath());

    private static String getAppDataPath() {
        if (OS.contains("WIN")) {
            return System.getenv("AppData");
        }
        Object appDataPath = System.getProperty("user.home");
        if (OS.contains("MAC")) {
            appDataPath = (String)appDataPath + File.separator + "Library" + File.separator + "Application Support";
        }
        return appDataPath;
    }

    private static String getGlobalOptionsPath() {
        String dot = ".";
        if (OS.contains("MAC")) {
            dot = "";
        }
        return Util.getAppDataPath() + File.separator + dot + "minecraft" + File.separator + "options.txt";
    }

    public static boolean isGloballyToggledOff() {
        try {
            if (dir.isDirectory() && globalOptionsFile.isFile()) {
                String optionsFileContent = new String(Files.readAllBytes(Paths.get(Util.getGlobalOptionsPath(), new String[0])));
                for (String line : optionsFileContent.split("\n")) {
                    int narratorSettingId;
                    String narratorSetting;
                    if (!line.startsWith("narrator:") || !NumberFunctions.isNumeric((String)(narratorSetting = line.split(":")[1].strip()))) continue;
                    Variables.currentNarrationId = narratorSettingId = Integer.parseInt(narratorSetting);
                    return narratorSettingId == 0;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void initGlobalSync(int newNarratorId) throws IOException {
        if (newNarratorId == Variables.currentNarrationId) {
            return;
        }
        if (!dir.isDirectory()) {
            boolean bl = dir.mkdirs();
        }
        StringBuilder optionsFileContent = new StringBuilder();
        if (globalOptionsFile.isFile()) {
            String currentOptionsFileContent = new String(Files.readAllBytes(Paths.get(Util.getGlobalOptionsPath(), new String[0])));
            for (String line : currentOptionsFileContent.split("\n")) {
                if (line.startsWith("narrator:")) {
                    optionsFileContent.append("narrator:").append(newNarratorId).append("\n");
                    continue;
                }
                optionsFileContent.append(line).append("\n");
            }
        } else {
            optionsFileContent.append("narrator:").append(newNarratorId);
        }
        FileWriter writer = new FileWriter(Util.getGlobalOptionsPath(), StandardCharsets.UTF_8, false);
        writer.write(optionsFileContent.toString());
        writer.close();
        Variables.currentNarrationId = newNarratorId;
    }
}

