/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.zombiehorsespawn_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.zombiehorsespawn_common_neoforge.config.ConfigHandler;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.equine.ZombieHorse;
import net.minecraft.world.level.Level;

public class ZombieHorseEvent {
    public static HashMap<Level, CopyOnWriteArrayList<Entity>> zombiehorses_per_world = new HashMap();
    public static HashMap<Level, Integer> tickdelay_per_world = new HashMap();

    public static void onEntityJoin(Level level, Entity entity) {
        if (level.isClientSide()) {
            return;
        }
        if (entity instanceof ZombieHorse && !((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(zombiehorses_per_world, (Object)level, k -> new CopyOnWriteArrayList())).contains(entity)) {
            zombiehorses_per_world.get(level).add(entity);
        }
    }

    public static void onWorldTick(ServerLevel level) {
        int ticks = (Integer)HashMapFunctions.computeIfAbsent(tickdelay_per_world, (Object)level, k -> 1);
        if (ticks % 20 != 0) {
            tickdelay_per_world.put((Level)level, ticks + 1);
            return;
        }
        tickdelay_per_world.put((Level)level, 1);
        if (!ConfigHandler.shouldBurnZombieHorsesInDaylight) {
            return;
        }
        if (!level.isBrightOutside()) {
            return;
        }
        for (Entity zombiehorse : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(zombiehorses_per_world, (Object)level, k -> new CopyOnWriteArrayList())) {
            if (zombiehorse.isAlive()) {
                BlockPos epos;
                if (zombiehorse.isInWaterOrRain() || !BlockPosFunctions.isOnSurface((Level)level, (BlockPos)(epos = zombiehorse.blockPosition())).booleanValue()) continue;
                zombiehorse.setRemainingFireTicks(60);
                continue;
            }
            zombiehorses_per_world.get(level).remove(zombiehorse);
        }
    }
}

