/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawningshulkers_common_forge.events;

import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.respawningshulkers_common_forge.config.ConfigHandler;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;

public class ShulkerEvent {
    private static final HashMap<Entity, Integer> shulkersTicksLeft = new HashMap();
    private static final HashMap<Level, CopyOnWriteArrayList<Entity>> respawnShulkers = new HashMap();

    public static void onWorldTick(ServerLevel serverLevel) {
        if (((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(respawnShulkers, (Object)serverLevel, k -> new CopyOnWriteArrayList())).size() > 0) {
            for (Entity shulker : respawnShulkers.get(serverLevel)) {
                int ticksleft = shulkersTicksLeft.get(shulker) - 1;
                if (ticksleft == 0) {
                    respawnShulkers.get(serverLevel).remove(shulker);
                    shulkersTicksLeft.remove(shulker);
                    serverLevel.addFreshEntity(shulker);
                    continue;
                }
                shulkersTicksLeft.put(shulker, ticksleft);
            }
        }
    }

    public static void onShulkerDeath(Level level, Entity entity, DamageSource source) {
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof Shulker)) {
            return;
        }
        Set tags = entity.getTags();
        if (tags.contains("collective.fromspawner") && ConfigHandler.shulkersFromSpawnersDoNotRespawn) {
            return;
        }
        if (tags.contains("flowermimics.mimic")) {
            return;
        }
        Shulker newshulker = (Shulker)EntityType.SHULKER.create(level, EntitySpawnReason.NATURAL);
        newshulker.restoreFrom(entity);
        newshulker.setHealth(30.0f);
        shulkersTicksLeft.put((Entity)newshulker, ConfigHandler.timeInTicksToRespawn);
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(respawnShulkers, (Object)level, k -> new CopyOnWriteArrayList())).add(newshulker);
    }

    public static void onServerShutdown(MinecraftServer server) {
        Set<Level> levels = respawnShulkers.keySet();
        for (Level level : levels) {
            for (Entity shulker : respawnShulkers.get(level)) {
                level.addFreshEntity(shulker);
            }
        }
    }
}

