/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.aprilfools_common_neoforge.features;

import com.natamus.aprilfools_common_neoforge.config.ConfigHandler;
import com.natamus.aprilfools_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpawnCreeperFirework {
    public static boolean init(Creeper creeper) {
        double explodeIntoFireworkChance = Util.setExtraAprilFoolsChance(ConfigHandler.chanceCreepersExplodeIntoFireworks);
        if (explodeIntoFireworkChance <= 0.0) {
            return false;
        }
        if (GlobalVariables.random.nextDouble() > explodeIntoFireworkChance) {
            return false;
        }
        Vec3 creeperVec = creeper.position();
        Level level = creeper.level();
        ItemStack fireworkItemStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 1);
        ArrayList<FireworkExplosion> explosionsList = new ArrayList<FireworkExplosion>();
        boolean hasTrail = true;
        boolean hasTwinkle = true;
        IntList colours = IntList.of((int)0x55FF55);
        IntList fadeColours = IntList.of((int)0xAA0000);
        FireworkExplosion fireworkExplosion = new FireworkExplosion(FireworkExplosion.Shape.CREEPER, colours, fadeColours, hasTrail, hasTwinkle);
        explosionsList.add(fireworkExplosion);
        Fireworks fireworks = new Fireworks(0, explosionsList);
        fireworkItemStack.set(DataComponents.FIREWORKS, (Object)fireworks);
        FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(level, creeperVec.x, creeperVec.y, creeperVec.z, fireworkItemStack);
        level.addFreshEntity((Entity)fireworkRocketEntity);
        creeper.discard();
        return true;
    }
}

