/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.recast_common_neoforge.events;

import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RecastEvent {
    private static final HashMap<Player, Vec3> recasting = new HashMap();
    private static final HashMap<FishingHook, Vec3> lastcastlocation = new HashMap();

    public static void onPlayerTick(ServerLevel serverLevel, ServerPlayer player) {
        ItemStack activestack;
        if (!recasting.containsKey(player)) {
            return;
        }
        ItemStack mainhand = player.getMainHandItem();
        if (!(mainhand.getItem() instanceof FishingRodItem)) {
            ItemStack offhand = player.getOffhandItem();
            if (!(offhand.getItem() instanceof FishingRodItem)) {
                recasting.remove(player);
                return;
            }
            activestack = offhand;
        } else {
            activestack = mainhand;
        }
        Vec3 fbvec = recasting.get(player);
        serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (GlobalVariables.random.nextFloat() * 0.4f + 0.8f));
        int k = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)activestack, (Entity)player) * 20.0f);
        int j = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)activestack, (Entity)player);
        FishingHook fbe = new FishingHook((Player)player, (Level)serverLevel, j, k);
        fbe.teleportTo(fbvec.x, fbvec.y, fbvec.z);
        serverLevel.addFreshEntity((Entity)fbe);
        player.awardStat(Stats.ITEM_USED.get((Object)Items.FISHING_ROD));
        recasting.remove(player);
        lastcastlocation.put(fbe, fbvec);
    }

    public static void onFishingCatch(List<ItemStack> loot, FishingHook fbe) {
        Player player = fbe.getPlayerOwner();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        Vec3 fbvec = fbe.position();
        if (lastcastlocation.containsKey(fbe)) {
            Vec3 lastvec = lastcastlocation.get(fbe);
            if (BlockPosFunctions.withinDistance((BlockPos)BlockPos.containing((double)fbvec.x, (double)fbvec.y, (double)fbvec.z), (BlockPos)BlockPos.containing((double)lastvec.x, (double)lastvec.y, (double)lastvec.z), (int)5).booleanValue()) {
                fbvec = lastvec;
            }
        }
        recasting.put(player, fbvec);
        lastcastlocation.remove(fbe);
    }
}

