/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_neoforge.events;

import com.mojang.authlib.GameProfile;
import com.natamus.justmobheads_common_neoforge.config.ConfigHandler;
import com.natamus.justmobheads_common_neoforge.util.HeadData;
import com.natamus.justmobheads_common_neoforge.util.MobHeads;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class HeadDropEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mobItemDrop(Level level, Entity entity, DamageSource damageSource) {
        ItemEntity mobhead;
        int looting;
        TamableAnimal te;
        if (level.isClientSide()) {
            return;
        }
        if (ConfigHandler.onlyDropHeadsByChargedCreeper || ConfigHandler.onlyDropHeadsByPlayerKill) {
            Entity sourceentity = damageSource.getDirectEntity();
            if (ConfigHandler.onlyDropHeadsByChargedCreeper) {
                if (!(sourceentity instanceof Creeper)) return;
                Creeper creeper = (Creeper)sourceentity;
                if (!creeper.isPowered()) {
                    return;
                }
            } else if (ConfigHandler.onlyDropHeadsByPlayerKill && !(sourceentity instanceof Player)) {
                return;
            }
        }
        if (ConfigHandler.onlyAdultMobsDropTheirHead && entity instanceof TamableAnimal && (te = (TamableAnimal)entity).isBaby()) {
            return;
        }
        String mobname = MobHeads.getName(entity);
        if (mobname.equals("")) {
            return;
        }
        double extrachance = 0.0;
        Entity source = damageSource.getEntity();
        if (ConfigHandler.enableLootingEnchant && source instanceof Player && (looting = EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING), (LivingEntity)((LivingEntity)source))) > 0) {
            extrachance = 0.025 + (double)((float)looting / 100.0f);
        }
        Object headname = "";
        if (mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton")) {
            if (!ConfigHandler.enableStandardHeads) return;
            headname = mobname.substring(0, 1).toUpperCase() + mobname.substring(1) + " Head";
        }
        double num = Math.random();
        if (ConfigHandler.mobSpecificDropChances) {
            double chance = -1.0;
            if (((String)headname).equals("")) {
                if (HeadData.headChances.containsKey(mobname)) {
                    chance = HeadData.headChances.get(mobname);
                }
            } else {
                chance = ConfigHandler.creeperSkeletonZombieDropChance;
            }
            if (chance == -1.0 ? num > ConfigHandler.overallDropChance + extrachance : num > chance + extrachance) {
                return;
            }
        } else if (num > ConfigHandler.overallDropChance + extrachance) {
            return;
        }
        BlockPos pos = entity.blockPosition();
        if (((String)headname).equals("")) {
            ItemStack headstack = MobHeads.getMobHead(mobname, 1);
            if (headstack == null) {
                return;
            }
            mobhead = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), headstack);
        } else {
            mobhead = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), MobHeads.getStandardHead((String)headname));
        }
        level.addFreshEntity((Entity)mobhead);
    }

    public static void onItemPickup(Level level, Player player, ItemStack itemStack) {
        if (level.isClientSide()) {
            return;
        }
        Item item = itemStack.getItem();
        if (!(item instanceof PlayerHeadItem)) {
            return;
        }
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            String headName;
            String dataHeadName;
            if (!itemStack.has(DataComponents.NOTE_BLOCK_SOUND) && HeadData.headNoteBlockSounds.containsKey(dataHeadName = (headName = ((Component)itemStack.get(DataComponents.CUSTOM_NAME)).getString()).replace(" Head", "").toLowerCase().replace(" ", "_"))) {
                itemStack.set(DataComponents.NOTE_BLOCK_SOUND, (Object)Identifier.parse((String)HeadData.headNoteBlockSounds.get(dataHeadName)));
            }
            return;
        }
        ResolvableProfile resolvableProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
        if (resolvableProfile == null) {
            return;
        }
        GameProfile gameProfile = resolvableProfile.partialProfile();
        if (gameProfile == null) {
            return;
        }
        String headName = gameProfile.name();
        if (headName == null) {
            return;
        }
        if (headName.isEmpty()) {
            return;
        }
        if (!HeadData.headTextureData.containsKey(headName.toLowerCase().replace(" ", "_"))) {
            return;
        }
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)(headName + " Head")));
    }
}

