/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.wanderingtradermayleave_common_forge.networking.packets;

import com.natamus.collective_common_forge.implementations.networking.api.Dispatcher;
import com.natamus.collective_common_forge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_forge.implementations.networking.data.Side;
import com.natamus.wanderingtradermayleave_common_forge.config.ConfigHandler;
import com.natamus.wanderingtradermayleave_common_forge.networking.packets.ToClientShowPoofParticlesPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.equine.TraderLlama;
import net.minecraft.world.entity.npc.wanderingtrader.WanderingTrader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ToServerMakeWanderingTraderLeavePacket {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"wanderingtradermayleave", (String)"to_server_make_wandering_trader_leave");

    public static ToServerMakeWanderingTraderLeavePacket decode(FriendlyByteBuf buf) {
        return new ToServerMakeWanderingTraderLeavePacket();
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static void handle(PacketContext<ToServerMakeWanderingTraderLeavePacket> ctx) {
        if (ctx.side().equals((Object)Side.SERVER)) {
            ToServerMakeWanderingTraderLeavePacket packet = (ToServerMakeWanderingTraderLeavePacket)ctx.message();
            ServerPlayer serverPlayer = (ServerPlayer)ctx.sender();
            ServerLevel level = serverPlayer.level();
            Vec3 pVec = serverPlayer.position();
            if (ConfigHandler.despawnTraderLlamasToo) {
                for (Entity entity : level.getEntitiesOfClass(TraderLlama.class, new AABB(pVec.x - 10.0, pVec.y - 10.0, pVec.z - 10.0, pVec.x + 10.0, pVec.y + 10.0, pVec.z + 10.0))) {
                    TraderLlama traderLlama;
                    if (!(entity instanceof TraderLlama) || !((traderLlama = (TraderLlama)entity).getLeashHolder() instanceof WanderingTrader) && ConfigHandler.onlyDespawnLlamasWhenLeashed) continue;
                    traderLlama.removeLeash();
                    traderLlama.remove(Entity.RemovalReason.DISCARDED);
                    if (!ConfigHandler.showDespawnParticles) continue;
                    Dispatcher.sendToClient((Object)new ToClientShowPoofParticlesPacket(traderLlama.getX(), traderLlama.getY(), traderLlama.getZ()), (ServerPlayer)serverPlayer);
                }
            }
            for (Entity entity : level.getEntitiesOfClass(WanderingTrader.class, new AABB(pVec.x - 10.0, pVec.y - 10.0, pVec.z - 10.0, pVec.x + 10.0, pVec.y + 10.0, pVec.z + 10.0))) {
                if (!(entity instanceof WanderingTrader)) continue;
                WanderingTrader wanderingTrader = (WanderingTrader)entity;
                wanderingTrader.setTradingPlayer(null);
                wanderingTrader.setDespawnDelay(1);
                if (!ConfigHandler.showDespawnParticles) continue;
                Dispatcher.sendToClient((Object)new ToClientShowPoofParticlesPacket(wanderingTrader.getX(), wanderingTrader.getY(), wanderingTrader.getZ()), (ServerPlayer)serverPlayer);
            }
        }
    }
}

