/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.omegamute_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.omegamute_common_neoforge.data.Constants;
import com.natamus.omegamute_common_neoforge.data.Variables;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class SoundEvents {
    public static boolean onSoundEvent(SoundEngine soundEngine, SoundInstance soundInstance) {
        int mutedValue;
        String rawName = soundInstance.getIdentifier().toString();
        Object prefix = "";
        boolean canPlay = true;
        if (Variables.isMutedSoundMap.containsKey(rawName) && (mutedValue = Variables.isMutedSoundMap.get(rawName).intValue()) >= 0) {
            if (mutedValue == 0) {
                prefix = "(muted) ";
                canPlay = false;
            } else {
                Date now = new Date();
                boolean replace = true;
                if (Variables.lastPlayedSound.containsKey(rawName)) {
                    Date then = Variables.lastPlayedSound.get(rawName);
                    long ms = now.getTime() - then.getTime();
                    if (ms < (long)mutedValue * 1000L) {
                        replace = false;
                        prefix = "(" + mutedValue + "-culled-muted) ";
                        canPlay = false;
                    }
                }
                if (replace) {
                    Variables.lastPlayedSound.put(rawName, now);
                    prefix = "(" + mutedValue + "-culled-allowed) ";
                }
            }
        }
        if (Variables.playerIsListening && Constants.mc.player != null && !rawName.endsWith(".hat")) {
            String[] nSpl = rawName.split(":");
            MutableComponent formattedNameComponent = nSpl.length == 2 ? Component.literal((String)nSpl[0]).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)":").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)nSpl[1]).withStyle(ChatFormatting.DARK_GREEN))) : Component.literal((String)nSpl[0]).withStyle(ChatFormatting.DARK_AQUA);
            formattedNameComponent = Component.literal((String)prefix).withStyle(ChatFormatting.GRAY).append((Component)formattedNameComponent);
            if (!Variables.listeningToAll) {
                if (Variables.soundsListenedTo.contains(rawName)) {
                    return canPlay;
                }
                Variables.soundsListenedTo.add(rawName);
            }
            MessageFunctions.sendMessage((Player)Constants.mc.player, (MutableComponent)formattedNameComponent);
        }
        return canPlay;
    }
}

