/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.omegamute.neoforge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.natamus.omegamute_common_neoforge.cmds.CommandOmega;
import com.natamus.omegamute_common_neoforge.data.Constants;
import com.natamus.omegamute_common_neoforge.data.Variables;
import com.natamus.omegamute_common_neoforge.events.SoundEvents;
import com.natamus.omegamute_common_neoforge.util.Util;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class NeoForgeSoundEvents {
    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load e) {
        if (Variables.soundFileLoaded) {
            return;
        }
        try {
            Util.loadSoundFile();
        }
        catch (Exception ex) {
            Constants.logger.warn("Something went wrong while generating the sound file.");
        }
        Variables.soundFileLoaded = true;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent e) {
        CommandOmega.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public static void onSoundEvent(PlaySoundEvent e) {
        if (!SoundEvents.onSoundEvent(e.getEngine(), e.getOriginalSound())) {
            e.setSound(null);
        }
    }
}

