/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.inventorymending_common_neoforge.mixin;

import com.natamus.inventorymending_common_neoforge.config.ConfigHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ExperienceOrb.class}, priority=999)
public class ExperienceOrbMixin {
    @Unique
    private static final Predicate<ItemStack> isDamagedPredicate = ItemStack::isDamaged;

    @ModifyVariable(method={"repairPlayerItems(Lnet/minecraft/server/level/ServerPlayer;I)I"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getRandomItemWith(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Optional;"))
    public Optional<EnchantedItemInUse> repairPlayerItems_optionalEnchantedItemInUse(Optional<EnchantedItemInUse> optionalEnchantedItemInUse, ServerPlayer serverPlayer, int n) {
        if (optionalEnchantedItemInUse.isEmpty()) {
            ArrayList<EnchantedItemInUse> list = new ArrayList<EnchantedItemInUse>();
            Inventory playerInventory = serverPlayer.getInventory();
            for (int i = 0; !(i >= playerInventory.getContainerSize() || ConfigHandler.mendToolbarOnly && i > 8); ++i) {
                ItemStack slotStack = playerInventory.getItem(i);
                if (!isDamagedPredicate.test(slotStack)) continue;
                ItemEnchantments itemEnchantments = (ItemEnchantments)slotStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    if (!((Enchantment)holder.value()).effects().has(EnchantmentEffectComponents.REPAIR_WITH_XP)) continue;
                    list.add(new EnchantedItemInUse(slotStack, EquipmentSlot.MAINHAND, (LivingEntity)serverPlayer));
                }
            }
            if (!list.isEmpty()) {
                return Util.getRandomSafe(list, (RandomSource)serverPlayer.getRandom());
            }
        }
        return optionalEnchantedItemInUse;
    }
}

