/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.followersteleporttoo_common_forge.events;

import com.natamus.followersteleporttoo_common_forge.config.ConfigHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportEvent {
    private static final HashMap<UUID, Date> teleportedfollowers = new HashMap();

    public static void onPlayerTeleport(Level world, Entity entity, double targetX, double targetY, double targetZ) {
        if (world.isClientSide()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPos ppos = player.blockPosition();
        Vec3 targetvec = new Vec3(targetX, targetY, targetZ);
        for (Entity ea : world.getEntities(null, new AABB((double)(ppos.getX() - 50), (double)(ppos.getY() - 50), (double)(ppos.getZ() - 50), (double)(ppos.getX() + 50), (double)(ppos.getY() + 50), (double)(ppos.getZ() + 50)))) {
            TamableAnimal ta;
            if (!(ea instanceof TamableAnimal) || !(ta = (TamableAnimal)ea).isTame() || ta.isInSittingPose() || !ta.isOwnedBy((LivingEntity)player)) continue;
            ta.teleportTo(targetvec.x, targetvec.y, targetvec.z);
            if (!ConfigHandler.disableFollowerDamageAfterTeleport) continue;
            teleportedfollowers.put(ta.getUUID(), new Date());
        }
    }

    public static float onFollowerDamage(Level level, Entity entity, DamageSource damageSource, float damageAmount) {
        if (!ConfigHandler.disableFollowerDamageAfterTeleport) {
            return damageAmount;
        }
        if (teleportedfollowers.size() > 0) {
            if (!(entity instanceof TamableAnimal)) {
                return damageAmount;
            }
            UUID uuid = entity.getUUID();
            if (teleportedfollowers.containsKey(uuid)) {
                Date lastteleported = teleportedfollowers.get(uuid);
                long ms = new Date().getTime() - lastteleported.getTime();
                if (ms > (long)ConfigHandler.durationInSecondsDamageShouldBeDisabled * 1000L) {
                    teleportedfollowers.remove(uuid);
                    return damageAmount;
                }
                return 0.0f;
            }
        }
        return damageAmount;
    }
}

