/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.moveboats_common_forge.events;

import java.util.HashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.boat.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BoatEvent {
    private static final HashMap<String, Entity> pickedUpBoats = new HashMap();
    private static final HashMap<String, Boolean> playerStoodUp = new HashMap();

    public static void onPlayerTick(ServerLevel world, ServerPlayer player) {
        String playerName = player.getName().getString();
        if (!pickedUpBoats.containsKey(playerName)) {
            return;
        }
        Entity pickedUpBoat = pickedUpBoats.get(playerName);
        for (Entity passenger : pickedUpBoat.getPassengers()) {
            if (!passenger.is((Entity)player)) continue;
            pickedUpBoats.remove(playerName);
            return;
        }
        boolean stoodUp = playerStoodUp.getOrDefault(playerName, false);
        if (!stoodUp) {
            if (!player.isCrouching()) {
                playerStoodUp.put(playerName, true);
            }
        } else if (player.isCrouching()) {
            pickedUpBoats.remove(playerName);
            playerStoodUp.remove(playerName);
            return;
        }
        Vec3 look = player.getLookAngle();
        float distance = 2.0f;
        double dx = player.getX() + look.x * (double)distance;
        double dy = player.getY() + (double)player.getEyeHeight();
        double dz = player.getZ() + look.z * (double)distance;
        pickedUpBoat.setPos(dx, dy, dz);
    }

    public static InteractionResult onBoatClick(Player player, Level world, InteractionHand hand, Entity target, EntityHitResult hitResult) {
        if (!(target instanceof Boat)) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide() || !hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        if (!player.isCrouching()) {
            return InteractionResult.PASS;
        }
        String playerName = player.getName().getString();
        pickedUpBoats.put(playerName, target);
        playerStoodUp.put(playerName, false);
        return InteractionResult.SUCCESS;
    }
}

