/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.betterconduitplacement_common_neoforge.events;

import com.natamus.betterconduitplacement_common_neoforge.config.ConfigHandler;
import com.natamus.betterconduitplacement_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ConduitEvent {
    public static InteractionResult onWaterClick(Player player, Level world, InteractionHand hand) {
        double dz;
        double dy;
        ItemStack itemstack = player.getItemInHand(hand);
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (!itemstack.getItem().equals(Items.CONDUIT)) {
            return InteractionResult.PASS;
        }
        Vec3 look = player.getLookAngle();
        float distance = 2.0f;
        double dx = player.getX() + look.x * (double)distance;
        BlockPos frontpos = BlockPos.containing((double)dx, (double)(dy = player.getY() + look.y * (double)distance + 2.0), (double)(dz = player.getZ() + look.z * (double)distance));
        if (!world.getBlockState(frontpos).getBlock().equals(Blocks.WATER)) {
            return InteractionResult.PASS;
        }
        world.setBlockAndUpdate(frontpos, Blocks.CONDUIT.defaultBlockState());
        if (!player.isCreative()) {
            itemstack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean onConduitClick(Level world, Player player, InteractionHand hand, BlockPos cpos, BlockHitResult hitVec) {
        BlockPos nextpos;
        if (world.isClientSide()) {
            return true;
        }
        if (!world.getBlockState(cpos).getBlock().equals(Blocks.CONDUIT)) {
            return true;
        }
        ItemStack handstack = player.getItemInHand(hand);
        if (!BlockFunctions.isOneOfBlocks(Util.conduitblocks, (ItemStack)handstack).booleanValue()) {
            return true;
        }
        boolean set = false;
        while (handstack.getCount() > 0 && (nextpos = Util.getNextLocation(world, cpos)) != null) {
            Block block = world.getBlockState(nextpos).getBlock();
            if (ConfigHandler.dropReplacedBlockTopConduit && !block.equals(Blocks.AIR) && !block.equals(Blocks.WATER)) {
                ItemEntity ei = new ItemEntity(world, (double)cpos.getX(), (double)(cpos.getY() + 1), (double)cpos.getZ(), new ItemStack((ItemLike)block, 1));
                world.addFreshEntity((Entity)ei);
            }
            world.setBlockAndUpdate(nextpos, Block.byItem((Item)handstack.getItem()).defaultBlockState());
            if (!player.isCreative()) {
                handstack.shrink(1);
            }
            set = true;
            if (player.isShiftKeyDown()) continue;
            break;
        }
        return !set;
    }

    public static void onBlockBreak(Level world, Player player, BlockPos bpos, BlockState state, BlockEntity blockEntity) {
        if (world.isClientSide()) {
            return;
        }
        if (!ConfigHandler.breakConduitBlocks) {
            return;
        }
        if (!state.getBlock().equals(Blocks.CONDUIT)) {
            return;
        }
        Util.destroyAllConduitBlocks(world, bpos);
    }
}

