/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.nametagtweaks_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.nametagtweaks_common_forge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class NametagCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nametag").requires(iCommandSender -> iCommandSender.getEntity() instanceof ServerPlayer)).executes(command -> {
            MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (String)"Usage: '/nametag <name>' while holding a name tag.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            ItemStack nametagstack;
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(Items.NAME_TAG)) {
                nametagstack = player.getItemInHand(InteractionHand.MAIN_HAND);
            } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem().equals(Items.NAME_TAG)) {
                nametagstack = player.getItemInHand(InteractionHand.OFF_HAND);
            } else {
                MessageFunctions.sendMessage((Player)player, (String)"Usage: '/nametag <name>' while holding a name tag.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            String name = StringArgumentType.getString((CommandContext)command, (String)"name");
            if (ConfigHandler.nameTagCommandReplaceUnderscoresWithSpaces) {
                name = name.replace("_", " ");
            }
            nametagstack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
            nametagstack.set(DataComponents.REPAIR_COST, (Object)0);
            MessageFunctions.sendMessage((Player)player, (String)("Set name value to '" + name + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })));
    }
}

