/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.sleepsooner_common_neoforge.events;

import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import com.natamus.sleepsooner_common_neoforge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;

public class PlayerEvent {
    public static boolean playerClick(Level level, Player player, InteractionHand hand, BlockPos hitpos, BlockHitResult hitVec) {
        if (level.isClientSide() || !hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return true;
        }
        if (!ConfigHandler.enableSleepSooner) {
            return true;
        }
        Block block = level.getBlockState(hitpos).getBlock();
        if (!(block instanceof BedBlock)) {
            return true;
        }
        int sleeptime = ConfigHandler.whenSleepIsPossibleInTicks;
        int currenttime = (int)level.getDayTime();
        int days = (int)Math.floor((double)currenttime / 24000.0);
        int daytime = currenttime - days * 24000;
        if (sleeptime > 12540 && daytime > 12540 && daytime < sleeptime) {
            MessageFunctions.sendMessage((Player)player, (String)"It's too early to sleep.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return false;
        }
        if (daytime > 12540) {
            return true;
        }
        if (daytime < sleeptime) {
            return true;
        }
        WorldFunctions.setWorldTime((ServerLevel)((ServerLevel)level), (Integer)12540);
        if (ConfigHandler.enablePreSleepMessage) {
            String unique = (String)GlobalVariables.lingerMessages.get(GlobalVariables.random.nextInt(GlobalVariables.lingerMessages.size()));
            MessageFunctions.sendMessage((Player)player, (String)("You " + unique + " until dusk. You may now sleep."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        return true;
    }
}

